<?php

/**
 * Theme options / Styles / Header
 *
 * @package wpv
 * @subpackage the-wedding-day
 */

return array(

array(
	'name' => __('Header', 'the-wedding-day'),
	'type' => 'start',

),

array(
	'name' => __('Where are these options used?', 'the-wedding-day'),
	'desc' => __('The header consist of the area above the body up to the top. It is divided in two main areas - the main menu area and the slider area. You can change the style of the main menu area using the options below.<br/>
		Please note that the theme uses Layered Slider and its option panel is found in the WordPress navigation menu on the left. ', 'the-wedding-day'),
	'type' => 'info',
),

array(
	'name' => __('Backgrounds', 'the-wedding-day'),
	'type' => 'separator',
),


array(
	'name' => __('Header Background', 'the-wedding-day'),
	'desc' => __('If you want to use an image as a background, enabling the cover button will resize and crop the image so that it will always fit the browser window on any resolution.<br>
	If the color opacity is less than 1 the page background underneath will be visible.', 'the-wedding-day'),
	'id' => 'header-background',
	'type' => 'background',
	'only' => 'color,image,repeat,position',
),

array(
	'name' => __('Sub-Header Background', 'the-wedding-day'),
	'desc' => __('If the color opacity is less than 1 the page background underneath will be visible.', 'the-wedding-day'),
	'id' => 'sub-header-background',
	'type' => 'background',
	'only' => 'color,image,repeat,size',
),

array(
	'name' => __('Typography', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('Site Title', 'the-wedding-day'),
	'desc' => sprintf(__('You can set the website title in <a href="%s" title="set website background">from here</a>. It is alternative to using an image logo.', 'the-wedding-day'), admin_url('options-general.php')),
	'id' => 'logo',
	'type' => 'font',
	'min' => 10,
	'max' => 60,
	'lmin' => 10,
	'lmax' => 90,
	'only' => 'size,face,weight,color',
),

array(
	'name' => __('Main Menu', 'the-wedding-day'),
	'desc' => sprintf(__('Please note that you have to use the WordPress custom menu feature located in <a href="%s" title="WordPress menus">Appearance - Menus</a>', 'the-wedding-day'), admin_url('nav-menus.php')),
	'id' => 'menu-font',
	'type' => 'font',
	'only' => 'size,face,weight,color',
	'min' => 10,
	'max' => 24,
	'lmin' => 10,
	'lmax' => 300,
	'class' => 'short-border',
),

array(
	'name' => '',
	'type' => 'color-row',
	'inputs' => array(
		'main-menu-hover-background' => array(
			'name' => __('Text Hover Background:', 'the-wedding-day'),
		),
		'css_menu_hover_color' => array(
			'name' => __('Text Hover Color:', 'the-wedding-day'),
		),
	),
),

array(
	'name' => __('Main Menu Sub-Menus', 'the-wedding-day'),
	'type' => 'color-row',
	'inputs' => array(
		'css_menu_background' => array(
			'name' => __('Background:', 'the-wedding-day'),
		),
		'css_submenu_color' => array(
			'name' => __('Text Normal Color:', 'the-wedding-day'),
		),
		'css_submenu_hover_color' => array(
			'name' => __('Text Hover Color:', 'the-wedding-day'),
		),
	),
),

array(
	'name' => __('Top Header Second Menu', 'the-wedding-day'),
	'desc' => sprintf(__('Please note that you have to use the WordPress custom menu feature located in <a href="%s" title="WordPress menus">Appearance - Menus</a>', 'the-wedding-day'), admin_url('nav-menus.php')),
	'type' => 'color-row',
	'inputs' => array(
		'css_tophead_link_color' => array(
			'name' => __('Text Normal Color:', 'the-wedding-day'),
		),
		'css_tophead_link_hover_color' => array(
			'name' => __('Text Hover Color:', 'the-wedding-day'),
		),
		'css_tophead_current_link_color' => array(
			'name' => __('Text Active Color:', 'the-wedding-day'),
		),
	),
),

	array(
		'type' => 'end'
	),
);