<?php
/**
 * Theme options / Styles / Footer
 * 
 * @package wpv
 * @subpackage the-wedding-day
 */

return array(
		
array(
	'name' => __('Footer', 'the-wedding-day'),
	'type' => 'start',	
),

array(
	'name' => __('Where are these options used?', 'the-wedding-day'),
	'desc' => __('The footer is the area below the body down to the bottom of your site. It consist of two main areas - the footer and the sub-footer. You can change the style of these areas using the options below.<br/>
		Please not that the footer map options are located in general settings - footer map tab.', 'the-wedding-day'),
	'type' => 'info',
),

array(
	'name' => __('Backgrounds', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('Widget Areas Background', 'the-wedding-day'),
	'desc' => __('If you want to use an image as a background, enabling the cover button will resize and crop the image so that it will always fit the browser window on any resolution. If the color opacity  is less than 1 the page background underneath will be visible.', 'the-wedding-day'),
	'id' => 'footer-background',
	'type' => 'background',
	'only' => 'color,opacity,image,repeat,size'
),

array(
	'name' => __('Sub-footer Background', 'the-wedding-day'),
	'desc' => __('If you want to use an image as a background, enabling the cover button will resize and crop the image so that it will always fit the browser window on any resolution.', 'the-wedding-day'),
	'id' => 'subfooter-background',
	'type' => 'background',
	'only' => 'color,image,repeat,size'
),

array(
	'name' => __('Typography', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('Widget Areas Text', 'the-wedding-day'),
	'desc' => __('This is the general font used for the footer widgets.', 'the-wedding-day'),
	'id' => 'footer-sidebars-font',
	'type' => 'font',
	'min' => 10,
	'max' => 32,
	'lmin' => 10,
	'lmax' => 64,
),

array(
	'name' => __('Widget Areas Titles', 'the-wedding-day'),
	'desc' => __('Please note that this option will override the general headings style set in the General Typography" tab.', 'the-wedding-day'),
	'id' => 'footer-sidebars-titles',
	'type' => 'font',
	'min' => 10,
	'max' => 32,
	'lmin' => 10,
	'lmax' => 64,
),

array(
	'name' => __('Sub-footer', 'the-wedding-day'),
	'desc' => __('You can place your text/HTML in the General Settings option page.', 'the-wedding-day'),
	'id' => 'sub-footer',
	'type' => 'font',
	'min' => 10,
	'max' => 32,
	'lmin' => 10,
	'lmax' => 64,
),

array(
	'name' => __('Links', 'the-wedding-day'),
	'type' => 'color-row',
	'inputs' => array(
		'css_footer_link_color' => array(
			'name' => __('Normal:', 'the-wedding-day'),
		),
		'css_footer_link_visited_color' => array(
			'name' => __('Visited:', 'the-wedding-day'),
		),
		'css_footer_link_hover_color' => array(
			'name' => __('Hover:', 'the-wedding-day'),
		),
	),
),

	array(
		'type' => 'end'
	),

);