<?php

/**
 * Theme options / Layout / General
 *
 * @package wpv
 * @subpackage the-wedding-day
 */

return array(
array(
	'name' => __('General', 'the-wedding-day'),
	'type' => 'start',
),

array(
	'name' => __('Responsive Layout', 'the-wedding-day'),
	'desc' => __('Enabling this option will make the layout respond to the screen resolutions.It is useful mostly on mobile phones.', 'the-wedding-day'),
	'id' => 'is-responsive',
	'type' => 'toggle',
	'class' => 'hidden',
),

array(
	'name' => __('Layout Type', 'the-wedding-day'),
	'desc' => __('Please note that in full width layout mode, the body background option found in Styles - Body, acts as page background.', 'the-wedding-day'),
	'id' => 'site-layout-type',
	'type' => 'select',
	'options' => array(
		'boxed' => __('Boxed', 'the-wedding-day'),
		'full' => __('Full width', 'the-wedding-day'),
	),
),

array(
	'name' => __('Maximum Page Width', 'the-wedding-day'),
	'desc' => sprintf(__('If you have changed this option, please use the <a href="%s" title="Regenerate thumbnails" target="_blank">Regenerate thumbnails</a> plugin in order to update your images.', 'the-wedding-day'), 'http://wordpress.org/extend/plugins/regenerate-thumbnails/'),
	'id' => 'site-max-width',
	'type' => 'select',
	'options' => array(
		1080 => '960px',
		1200 => '1080px',
		1380 => '1260px',
	),
),

	array(
		'type' => 'end'
	),
);