<?php

/**
 * Theme options / Import / Quick Import
 *
 * @package wpv
 * @subpackage church-event
 */

$disabled = $disabled_content = '';

if ( wpv_get_option( 'used-one-click-import' ) ) {
	$disabled_content = 'disabled';
}

$layerslider = function_exists( 'is_plugin_active' ) && is_plugin_active( 'layerslider/layerslider.php' );

return array(

array(
	'name' => __( 'Quick Import', 'the-wedding-day' ),
	'type' => 'start',
	'nosave' => true,
),

array(
	'name' => __('What is included in the content import?', 'the-wedding-day'),
	'desc' => __('The sample data for the Contact Form 7 plugin is part of the "content import". If you indend to use this plugin now or at a later time, please make sure that you have installed and enabled it <strong>before</strong> importing the demo content.', 'the-wedding-day'),
	'type' => 'info',
	'visible' => true,
),

array(
	'name' => __( 'Content Import', 'the-wedding-day' ),
	'desc' => __( 'You are advised to use this importer only on new WordPress sites, as in doing so you will end up with quite a lot of example posts, pages, slides and portfolio items.', 'the-wedding-day' ),
	'title' => __( 'Import Dummy Content', 'the-wedding-day' ),
	'link' => $disabled_content !== 'disabled' ? wp_nonce_url( admin_url( 'admin.php?import=wpv&step=2' ), 'wpv-import' ) : 'javascript:void( 0 )',
	'type' => 'button',
	'button_class' => "$disabled_content",
),

array(
	'name' => __( 'Widget Import', 'the-wedding-day' ),
	'desc' => __( 'Using this importer will overwrite your current sidebar settings', 'the-wedding-day' ),
	'title' => __( 'Import Widgets', 'the-wedding-day' ),
	'link' => wp_nonce_url( admin_url( 'admin.php?import=wpv_widgets' ), 'wpv-import' ),
	'type' => 'button',
),

array(
	'name' => __('LayerSlider', 'the-wedding-day'),
	'desc' => __('The theme uses Layered Slider and its option panel is found in the WordPress main navigation menu on the left.<br/>You will import the sliders seen in the demo website using this importer.', 'the-wedding-day'),
	'title' => __('Import Layer Slider Samples', 'the-wedding-day'),
	'link' => $layerslider ? wp_nonce_url( 'admin.php?import=vamtam_layerslider', 'vamtam-import-layerslider' ) : 'javascript:void(0)',
	'type' => 'button',
	'button_class' => $layerslider ? '' : 'disabled',
),

	array(
		'type' => 'end',
	),

);