<?php

/**
 * Theme options / General / Posts
 *
 * @package wpv
 * @subpackage the-wedding-day
 */

return array(

array(
	'name' => __('Posts', 'the-wedding-day'),
	'type' => 'start',

),

array(
	'name' => __('Blog and Portfolio Listing Pages and Archives', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('Pagination Type', 'the-wedding-day'),
	'desc' => __('Please note that you will need WP-PageNavi plugin installed if you chose "paged" style.', 'the-wedding-day'),
	'id' => 'pagination-type',
	'type' => 'select',
	'options' => array(
		'paged' => __('Paged', 'the-wedding-day'),
		'load-more' => __('Load more button', 'the-wedding-day'),
		'infinite-scrolling' => __('Infinite scrolling', 'the-wedding-day'),
	),
	'class' => 'slim',
),


array(
	'name' => __('Blog Posts', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('"View All Posts" Link', 'the-wedding-day'),
	'desc' => __('In a single blog post view in the top you will find navigation with 3 buttons. The middle gets you to the blog listing view.<br>
You can place the link here.', 'the-wedding-day'),
	'id' => 'post-all-items',
	'type' => 'text',
	'static' => true,
	'class' => 'slim',
),

array(
	'name' => __('Show "Related Posts" in Single Post View', 'the-wedding-day'),
	'desc' => __('Enabling this option will show more posts from the same category when viewing a single post.', 'the-wedding-day'),
	'id' => 'show-related-posts',
	'type' => 'toggle',
	'class' => 'slim',
),

array(
	'name' => __('"Related Posts" title', 'the-wedding-day'),
	'id' => 'related-posts-title',
	'type' => 'text',
	'class' => 'slim',
),

array(
	'name' => __('Show Post Author', 'the-wedding-day'),
	'desc' => __('Blog post meta info, works for the single blog post view.', 'the-wedding-day'),
	'id' => 'show-post-author',
	'type' => 'toggle',
	'class' => 'slim'
),
array(
	'name' => __('Show Categories and Tags', 'the-wedding-day'),
	'desc' => __('Blog post meta info, works for the single blog post view.', 'the-wedding-day'),
	'id' => 'meta_posted_in',
	'type' => 'toggle',
	'class' => 'slim',
),
array(
	'name' => __('Show Post Timestamp', 'the-wedding-day'),
	'desc' => __('Blog post meta info, works for the single blog post view.', 'the-wedding-day'),
	'id' => 'meta_posted_on',
	'type' => 'toggle',
	'class' => 'slim',
),
array(
	'name' => __('Show Comment Count', 'the-wedding-day'),
	'desc' => __('Blog post meta info, works for the single blog post view.', 'the-wedding-day'),
	'id' => 'meta_comment_count',
	'type' => 'toggle',
	'class' => 'slim',
),

array(
	'name' => __('Portfolio Posts', 'the-wedding-day'),
	'type' => 'separator',
),

array(
	'name' => __('"View All Portfolios" Link', 'the-wedding-day'),
	'desc' => __('In a single portfolio post view in the top you will find navigation with 3 buttons. The middle gets you to the portfolio listing view.<br>
You can place the link here.', 'the-wedding-day'),
	'id' => 'portfolio-all-items',
	'type' => 'text',
	'static' => true,
	'class' => 'slim',
),
array(
	'name' => __('Show "Related Portfolios" in Single Portfolio View', 'the-wedding-day'),
	'desc' => __('Enabling this option will show more portfolio posts from the same category in the single portfolio post.', 'the-wedding-day'),
	'id' => 'show-related-portfolios',
	'type' => 'toggle',
	'class' => 'slim',
),

array(
	'name' => __('"Related Portfolios" title', 'the-wedding-day'),
	'id' => 'related-portfolios-title',
	'type' => 'text',
	'class' => 'slim',
),

	array(
		'type' => 'end'
	),
);