<?php

/**
 * Theme options / General / General Settings
 *
 * @package wpv
 * @subpackage the-wedding-day
 */

return array(
array(
	'name' => __('General Settings', 'the-wedding-day'),
	'type' => 'start'
),

array(
	'name' => __('Custom Logo Picture', 'the-wedding-day'),
	'desc' => __('Optional way to replace "heading" and "description" text for your website with an image. Leave blank if none required.', 'the-wedding-day'),
	'id' => 'custom-header-logo',
	'type' => 'upload',
	'static' => true,
),

array(
	'name' => __('High Resolution Logo', 'the-wedding-day'),
	'desc' => __('Optional way to replace "heading" and "description" text for your website with an image. Leave blank if none required.', 'the-wedding-day'),
	'id' => 'custom-header-logo2x',
	'type' => 'upload',
	'static' => true,
),

array(
	'name' => __('Combine the Logo and Site Title', 'the-wedding-day'),
	'id' => 'combined-logo-title',
	'type' => 'toggle',
	'static' => true,
),

array(
	'name' => __('Google Maps API Key', 'the-wedding-day'),
	'desc'   => __("This option is required since June 22, 2016. Paste your Google Maps API Key here. If you don't have one, please sign up for a <a href='https://developers.google.com/maps/documentation/javascript/get-api-key'>Google Maps API key</a>.", 'the-wedding-day'),
	'id' => 'gmap_api_key',
	'type' => 'text',
	'static' => true,
),

array(
	'name' => __('Google Analytics Key', 'the-wedding-day'),
	'desc' => __("Paste your key here. It should be something like UA-XXXXX-X. We're using the faster asynchronous loader, so you don't need to worry about speed.", 'the-wedding-day'),
	'id' => 'analytics_key',
	'type' => 'text',
	'static' => true,
),

array(
	'name' => __('"Scroll to Top" Button', 'the-wedding-day'),
	'desc' => __('It is found in the bottom right side. It is sole purpose is help the user scroll a long page quickly to the top.', 'the-wedding-day'),
	'id' => 'show_scroll_to_top',
	'type' => 'toggle',
),

array(
	'name' => __('Feedback Button', 'the-wedding-day'),
	'desc' => __('It is found on the right hand side of your website. You can chose from a "link" or a slide out form(widget area).The slide out form is configured as a standard widget. You can use the same form you are using for your "contact us" page.', 'the-wedding-day'),
	'id' => 'feedback-type',
	'type' => 'select',
	'options' => array(
		'none' => __('None', 'the-wedding-day'),
		'link' => __('Link', 'the-wedding-day'),
		'sidebar' => __('Slide out widget area', 'the-wedding-day'),
	),
),

array(
	'name' => __('Feedback Button Link', 'the-wedding-day'),
	'desc' => __('If you have chosen a "link" in the option above, place the link of the button here, usually to your contact us page.', 'the-wedding-day'),
	'id' => 'feedback-link',
	'type' => 'text',
),

array(
	'name' => __('Share Icons', 'the-wedding-day'),
	'desc' => __('Select the social media you want enabled and for which parts of the website', 'the-wedding-day'),
	'type' => 'social',
	'static' => true,
),

array(
	'name' => __('Custom JavaScript', 'the-wedding-day'),
	'desc' => __('If the hundreds of options in the Theme Options Panel are not enough and you need customisation that is outside of the scope of the Theme Option Panel please place your javascript in this field. The contents of this field are placed near the <strong>&lt;/body&gt;</strong> tag, which improves the load times of the page.', 'the-wedding-day'),
	'id' => 'custom_js',
	'type' => 'textarea',
	'rows' => 15,
	'static' => true,
),

array(
	'name' => __('Custom CSS', 'the-wedding-day'),
	'desc' => __('If the hundreds of options in the Theme Options Panel are not enough and you need customisation that is outside of the scope of the Theme Options Panel please place your CSS in this field.', 'the-wedding-day'),
	'id' => 'custom_css',
	'type' => 'textarea',
	'rows' => 15,
	'class' => 'top-desc',
),

array(
	'type' => 'end'
)
);