<?php

class wpv_contactinfo extends WP_Widget {
	private $fields = array();

	function __construct() {
		$widget_ops = array(
			'classname' => 'wpv_contactinfo',
			'description' => __('Display contact information.', 'the-wedding-day')
		);
		parent::__construct('wpv_contactinfo', __('Vamtam - Contact Info', 'the-wedding-day') , $widget_ops);

		$this->fields = array(
			'title' => array('description' => __('Title:', 'the-wedding-day')),
			'name' => array('description' => __('Name:', 'the-wedding-day')),
			// 'text' => array('description' => __('Introduction text:', 'the-wedding-day')),
			'phone' => array('description' => __('Phone:', 'the-wedding-day')),
			'cellphone' => array('description' => __('Cell phone:', 'the-wedding-day')),
			'mail' => array('description' => __('Email:', 'the-wedding-day')),
			'address' => array('description' => __('Address:', 'the-wedding-day')),
		);
	}

	public function widget($args, $instance) {
		extract($args);
		foreach($this->fields as $name=>&$field)
			$field['value'] = isset($instance[$name]) ? $instance[$name] : '';
		unset($field);

		$title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);
		$color = $instance['color'];

		include(locate_template('templates/widgets/front/contactinfo.php'));
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		foreach($this->fields as $name=>$field)
			$instance[$name] = strip_tags($new_instance[$name]);

		$instance['color'] = $new_instance['color'];

		return $instance;
	}

	public function form($instance) {
		foreach($this->fields as $name=>&$field)
			$field['value'] = isset($instance[$name]) ? esc_attr($instance[$name]) : '';
		unset($field);

		$color = $instance['color'];

		include(locate_template('templates/widgets/conf/contactinfo.php'));
	}
}
register_widget('wpv_contactinfo');
