<?php

class WPV_Sc_Countdown {
	public function __construct() {
		add_shortcode('wpv_countdown', array(&$this, 'shortcode'));
	}

	public function shortcode($atts, $content = null, $code = null ) {
		extract(shortcode_atts(array(
			'datetime' => '',
			'done' => '',
		), $atts));

		ob_start();

		?>
		<div class="wpv-countdown" data-until="<?php echo esc_attr(strtotime($datetime)) ?>" data-done="<?php echo esc_attr($done) ?>">
			<span class="wpvc-days wpvc-block">
				<div class="value"></div>
				<div class="value-label"><?php _e('Days', 'the-wedding-day') ?></div>
			</span>
			<span class="wpvc-sep">:</span>
			<span class="wpvc-hours wpvc-block">
				<div class="value"></div>
				<div class="value-label"><?php _e('Hours', 'the-wedding-day') ?></div>
			</span>
			<span class="wpvc-sep">:</span>
			<span class="wpvc-minutes wpvc-block">
				<div class="value"></div>
				<div class="value-label"><?php _e('Minutes', 'the-wedding-day') ?></div>
			</span>
			<span class="wpvc-sep">:</span>
			<span class="wpvc-seconds wpvc-block">
				<div class="value"></div>
				<div class="value-label"><?php _e('Seconds', 'the-wedding-day') ?></div>
			</span>
		</div>
<?php
		return ob_get_clean();
	}
}

new WPV_Sc_Countdown;
