<?php

/**
 * Column shortcodes handler
 *
 * @package wpv
 * @subpackage editor
 */

/**
 * class WPV_Columns
 */
class WPV_Columns {
	/**
	 * Current row
	 *
	 * @var integer
	 */
	public static $in_row = 0;
	/**
	 * Last row
	 * @var integer
	 */
	public static $last_row = -1;

	/**
	 * Register the shortcodes
	 */
	public function __construct() {
		$GLOBALS['wpv_column_stack'] = array();

		for($i=0; $i<20; $i++) {
			$suffix = ($i==0) ? '' : '_'.$i;
			add_shortcode('column'.$suffix, array(&$this, 'dispatch'));
		}
	}

	/**
	 * Column shortcode callback
	 *
	 * @param  array  $atts    shortcode attributes
	 * @param  string $content shortcode content
	 * @param  string $code    shortcode name
	 * @return string          output html
	 */
	public function dispatch($atts, $content, $code) {
		extract(shortcode_atts(array(
			'animation' => 'none',
			'background_attachment' => 'scroll',
			'background_color' => '',
			'background_image' => '',
			'background_position' => '',
			'background_repeat' => '',
			'background_size' => '',
			'class' => '',
			'extended' => 'false',
			'extended_padding' => 'true',
			'last' => 'false',
			'parallax_bg' => 'disabled',
			'parallax_bg_inertia' => '1',
			'title' => '',
			'title_type' => 'single',
			'vertical_padding_bottom' => '0',
			'vertical_padding_top' => '0',
			'width' => '1/1',
			'div_atts' => '',
		), $atts));

		if(!preg_match('/column_\d+/', $code))
			$class .= ' wpv-first-level';

		$GLOBALS['wpv_column_stack'][] = $width;
		$GLOBALS['wpv_last_column_title'] = $title;

		if($parallax_bg !== 'disabled') {
			$class .= ' parallax-bg';
			$div_atts .= ' data-parallax-method="'.esc_attr($parallax_bg).'" data-parallax-inertia="'.esc_attr($parallax_bg_inertia).'"';
			$background_position = 'center top';
			$background_attachment = 'fixed';
		}

		$has_price = (strpos($content, '[price') !== false);
		$has_vertical_tabs = preg_match('/\[tabs.+layout="vertical"/s', $content);

		$width = str_replace('/', '-', $width);
		$title = !empty($title) && !$has_vertical_tabs && $parallax_bg == 'disabled' ? apply_filters('wpv_column_title', $title, $title_type) : '';

		$extended = wpv_sanitize_bool($extended);
		$last = wpv_sanitize_bool($last);
		$first = !$last;

		$id = 'wpv-column-'.md5(uniqid());

		if ( $width === '1-1' ) {
			$first = true;
			$last  = true;
		}

		if ( $width !== '1-1' || VamtamTemplates::get_layout() !== 'full' ) {
			$extended = false;
		}

		$result = '';
		$result_before = $result_after = $content_before = $content_after = '';

		if(self::$in_row > self::$last_row) {
			$rowclass = ($has_price) ? 'has-price' : '';

			$class .= ' first';
			$result .= '<div class="row '.$rowclass.'">';
			self::$last_row = self::$in_row;
		}

		if(!empty($background_image)) {
			$background_image = "
				background: url('$background_image') $background_repeat $background_position;
				background-size: $background_size;
				background-attachment: $background_attachment;
			";
		}

		if(!empty($background_color) && $background_color !== 'transparent') {
			$l = new WpvLessc();
			$l->importDir = '.';
			$l->setFormatter("compressed");

			$color = wpv_sanitize_accent($background_color);

			$inner_style = $l->compile(VamtamOverrides::lesscss_readable_color()."
				#{$id} {
					p,
					em,
					.column-title,
					.sep-text .regular-title-wrapper,
					.text-divider-double,
					.sep-text .sep-text-line,
					.sep,
					.sep-2,
					.sep-3 {
						.readable-color($color);
					}
				}
			");

			$background_color = "background-color:".wpv_sanitize_accent($background_color).";";
			$content_before .= '<style scoped>'.$inner_style.'</style>';
		} else {
			$background_color = '';
		}

		if(!empty($background_image) || (!empty($background_color) && $background_color !== 'transparent'))
			$class .= ' has-background';

		$vertical_padding_top = intval($vertical_padding_top).'px';
		$vertical_padding_bottom = intval($vertical_padding_bottom).'px';

		$style = 'style="'.$background_image.$background_color.'padding-top:'.$vertical_padding_top.';padding-bottom:'.$vertical_padding_bottom.'"';

		$class .= $extended ? ' extended' : ' unextended';

		if($animation !== 'none' && $parallax_bg == 'disabled')
			$class .= ' animation-'.$animation.' animated-active';

		if($extended_padding === 'false')
			$class .= ' no-extended-padding';

		if($extended) {
			$content_before = '<div class="extended-column-inner">'.$content_before;
			$content_after .= '</div>';
		}

		$result .= '<div class="wpv-grid grid-'.$width.' '.$class.'" '.$style.' id="'.$id.'" '.$div_atts.'>' . $content_before . $title . $this->content($content) . $content_after . '</div>';

		if($last) {
			self::$last_row--;

			$result .= '</div>';
		}

		array_pop($GLOBALS['wpv_column_stack']);

		return $result_before.$result.$result_after;
	}

	/**
	 * Parse column content
	 *
	 * @param  string $content unparsed content
	 * @return string          parsed content
	 */
	public function content($content) {
		self::$in_row++;
		$content = do_shortcode(trim($content));
		self::$in_row--;

		return $content;
	}
};

new WPV_Columns;
