<?php

/**
 * Blockquote shortcode handler
 *
 * @package wpv
 * @subpackage editor
 */

/**
 * class WPV_Blockquote
 */
class WPV_Blockquote {
	/**
	 * Register the shortcodes
	 */
	public function __construct() {
		add_shortcode('blockquote', array(__CLASS__, 'dispatch'));
	}

	/**
	 * Blockquote shortcode callback
	 *
	 * @param  array  $atts    shortcode attributes
	 * @param  string $content shortcode content
	 * @param  string $code    shortcode name
	 * @return string          output html
	 */
	public static function dispatch($atts, $content, $code) {
		extract(shortcode_atts(array(
			'layout' => 'slider',
			'cat' => '',
			'ids' => '',
		), $atts));

		$query = array(
			'post_type' => 'testimonials',
			'orderby' => 'menu_order',
			'order' => 'DESC',
			'posts_per_page' => -1,
		);

		if(!empty($cat)) {
			$query['tax_query'] = array(
				array(
					'taxonomy' => 'testimonials_category',
					'field' => 'slug',
					'terms' => explode(',', $cat),
				)
			);
		}

		if($ids && $ids != 'null')
			$query['post__in'] = explode(',',$ids);

		$q = new WP_Query($query);

		$output = '';

		if($layout == 'slider') {
			wp_enqueue_script( 'cubeportfolio' );
			wp_enqueue_style( 'cubeportfolio' );

			$slider_options = array(
				'layoutMode' => 'slider',
				'drag' => true,
				'auto' => wpv_sanitize_bool( $autorotate ),
				'autoTimeout' => 5000,
				'autoPauseOnHover' => true,
				'showNavigation' => false,
				'showPagination' => true,
				'rewindNav' => true,
				'scrollByPage' => false,
				'gridAdjustment' => 'responsive',
				'mediaQueries' => array( array(
						'width' => 1,
						'cols' => 1,
					),
				),
				'gapHorizontal' => 0,
				'gapVertical' => 0,
				'caption' => '',
				'displayType' => 'default',
			);

			$output .= '<div class="vamtam-cubeportfolio cbp cbp-slider-edge vamtam-testimonials-slider" data-options="' . esc_attr( json_encode( $slider_options ) ) . '">';

			while ( $q->have_posts() ) {
				$q->the_post();

				$output .= '<div class="cbp-item">';
				$output .= self::format();
				$output .= '</div>';
			}

			$output .= '</div>';
		} else {
			$output .= '<div class="blockquote-list">';

			while($q->have_posts()) {
				$q->the_post();

				$output .= self::format();
			}

			$output .= '</div>';
		}

		wp_reset_postdata();

		return $output;
	}

	private static function format() {
		$content = get_the_content();
		$cite = get_post_meta( get_the_ID(), 'testimonial-author', true );
		$link = get_post_meta( get_the_ID(), 'testimonial-link', true );
		$title = get_the_title();

		if(!empty($link))
			$cite = '<a href="'.$link.'" target="_blank">'.$cite.'</a>';

		$cite = "<p class='cite'>$cite</p>";

		$thumbnail = '';
		if(has_post_thumbnail())
			$thumbnail = get_the_post_thumbnail( get_the_ID(), 'thumbnail', array('class' => 'quote-thumbnail'));

		if(!empty($title)) {
			$title = "<strong class='quote-title'>$title:</strong>";
		}

		return "<blockquote class='clearfix small simple'>$thumbnail<div class='quote-text'>".$title.do_shortcode($content).$cite."</div></blockquote>";
	}
};

new WPV_Blockquote;
