<?php

/**
 * Slogan shortcode options
 *
 * @package wpv
 * @subpackage editor
 */

return array(
	'name' => __('Call Out Box', 'the-wedding-day') ,
	'desc' => __('You can place the call out box into а column - color box elemnent in order to have background color.' , 'the-wedding-day'),
	'icon' => array(
		'char' => WPV_Editor::get_icon('font-size'),
		'size' => '30px',
		'lheight' => '45px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'slogan',
	'controls' => 'size name clone edit delete handle',
	'options' => array(
		array(
			'name' => __('Content', 'the-wedding-day') ,
			'id' => 'html-content',
			'default' => __('<h1>You can place your call out box text here</h1>', 'the-wedding-day'),
			'type' => 'editor',
			'holder' => 'textarea',
		) ,
		array(
			'name' => __('Button Text', 'the-wedding-day') ,
			'id' => 'button_text',
			'default' => 'Button Text',
			'type' => 'text'
		) ,
		array(
			'name' => __('Button Link', 'the-wedding-day') ,
			'id' => 'link',
			'default' => '',
			'type' => 'text'
		) ,
		array(
			'name' => __('Button Icon', 'the-wedding-day') ,
			'id' => 'button_icon',
			'default' => 'cart',
			'type' => 'icons',
		) ,
		array(
			'name' => __('Button Icon Style', 'the-wedding-day'),
			'type' => 'select-row',
			'selects' => array(
				'button_icon_color' => array(
					'desc' => __('Color:', 'the-wedding-day'),
					"default" => "accent 1",
					"prompt" => '',
					"options" => array(
						'accent1' => __('Accent 1', 'the-wedding-day'),
						'accent2' => __('Accent 2', 'the-wedding-day'),
						'accent3' => __('Accent 3', 'the-wedding-day'),
						'accent4' => __('Accent 4', 'the-wedding-day'),
						'accent5' => __('Accent 5', 'the-wedding-day'),
						'accent6' => __('Accent 6', 'the-wedding-day'),
						'accent7' => __('Accent 7', 'the-wedding-day'),
						'accent8' => __('Accent 8', 'the-wedding-day'),
					) ,
				),
				'button_icon_placement' => array(
					'desc' => __('Placement:', 'the-wedding-day'),
					"default" => 'left',
					"options" => array(
						'left' => __('Left', 'the-wedding-day'),
						'right' => __('Right', 'the-wedding-day'),
					) ,
				),
				),
		),
		array(
			'name' => __('Element Animation (optional)', 'the-wedding-day') ,
			'id' => 'column_animation',
			'default' => 'none',
			'type' => 'select',
			'options' => array(
				'none' => __('No animation', 'the-wedding-day'),
				'from-left' => __('Appear from left', 'the-wedding-day'),
				'from-right' => __('Appear from right', 'the-wedding-day'),
				'fade-in' => __('Fade in', 'the-wedding-day'),
			),
		) ,
		
	) ,
);
