<?php
return array(
	"name" => "Sitemap",
	'icon' => array(
		'char' => WPV_Editor::get_icon('list'),
		'size' => '30px',
		'lheight' => '45px',
		'family' => 'vamtam-editor-icomoon',
	),
	"value" => "sitemap",
	'controls' => 'size name clone edit delete',
	'class' => 'slim',
	"options" => array(
		array(
			'name' => __('General', 'the-wedding-day'),
			'type' => 'separator',
		),
			array(
				"name" => __("Filter", 'the-wedding-day') ,
				"id" => "shows",
				"default" => array(),
				"options" => array(
					"pages" => __("Pages", 'the-wedding-day') ,
					"categories" => __("Categories", 'the-wedding-day') ,
					"posts" => __("Posts", 'the-wedding-day') ,
					"portfolios" => __("Portfolios", 'the-wedding-day') ,
				) ,
				"type" => "multiselect",
			) ,

			array(
				"name" => __("Limit", 'the-wedding-day') ,
				"desc" => __("Sets the number of items to display.<br>leaving this setting as 0 displays all items.", 'the-wedding-day') ,
				"id" => "number",
				"default" => 0,
				"min" => 0,
				"max" => 200,
				"type" => "range"
			) ,

			array(
				"name" => __("Depth", 'the-wedding-day') ,
				"desc" => __("This parameter controls how many levels in the hierarchy are to be included. <br> 0: Displays pages at any depth and arranges them hierarchically in nested lists<br> -1: Displays pages at any depth and arranges them in a single, flat list<br> 1: Displays top-level Pages only<br> 2, 3 … Displays Pages to the given depth", 'the-wedding-day') ,
				"id" => "depth",
				"default" => 0,
				"min" => - 1,
				"max" => 5,
				"type" => "range"
			) ,

		array(
			'name' => __('Posts and portfolios', 'the-wedding-day'),
			'type' => 'separator',
		),
			array(
				"name" => __("Show comments", 'the-wedding-day') ,
				"id" => "show_comment",
				"desc" => '',
				"default" => true,
				"type" => "toggle"
			) ,
			array(
				"name" => __("Specific post categories", 'the-wedding-day') ,
				"id" => "post_categories",
				"default" => array() ,
				"target" => 'cat',
				"type" => "multiselect",
			) ,
			array(
				"name" => __("Specific posts", 'the-wedding-day') ,
				"desc" => __("The specific posts you want to display", 'the-wedding-day') ,
				"id" => "posts",
				"default" => array() ,
				"target" => 'post',
				"type" => "multiselect",
			) ,
			array(
				"name" => __("Specific portfolio categories", 'the-wedding-day') ,
				"id" => "portfolio_categories",
				"default" => array() ,
				"target" => 'portfolio_category',
				"type" => "multiselect",
			) ,
		
		array(
			'name' => __('Categories', 'the-wedding-day'),
			'type' => 'separator',
		),
			array(
				"name" => __("Show Count", 'the-wedding-day') ,
				"id" => "show_count",
				"desc" => __("Toggles the display of the current count of posts in each category.", 'the-wedding-day') ,
				"default" => true,
				"type" => "toggle"
			) ,
			array(
				"name" => __("Show Feed", 'the-wedding-day') ,
				"id" => "show_feed",
				"desc" => __("Display a link to each category's <a href='http://codex.wordpress.org/Glossary#RSS' target='_blank'>rss-2</a> feed.", 'the-wedding-day') ,
				"default" => true,
				"type" => "toggle"
			) ,
			array(
			'name' => __('Title', 'the-wedding-day') ,
			'desc' => __('The column title is placed just above the element.', 'the-wedding-day'),
			'id' => 'column_title',
			'default' => '',
			'type' => 'text'
		) ,
		array(
			'name' => __('Title Type (optional)', 'the-wedding-day') ,
			'id' => 'column_title_type',
			'default' => 'single',
			'type' => 'select',
			'options' => array(
				'single' => __('Title with divider next to it', 'the-wedding-day'),
				'double' => __('Title with divider below', 'the-wedding-day'),
				'no-divider' => __('No Divider', 'the-wedding-day'),
			),
		) ,
	) ,
);
