<?php
return array(
	'name' => __('Service Box', 'the-wedding-day') ,
	'desc' => __('Please note that the service box may not work properly in one half to full width layouts.' , 'the-wedding-day'),
	'icon' => array(
		'char' => WPV_Editor::get_icon('cog1'),
		'size' => '30px',
		'lheight' => '45px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'services',
	'controls' => 'size name clone edit delete',
	'options' => array(
		array(
			'name' => __('Style', 'the-wedding-day') ,
			'id' => 'fullimage',
			'default' => 'false',
			'type' => 'select',
			'options' => array(
				'false' => __('Style big icon with zoom out', 'the-wedding-day'),
				'true' => __('Style standard with an image or an icon ', 'the-wedding-day'),
			),
			'field_filter' => 'fbs',
		) ,

		array(
			'name' => __('Icon', 'the-wedding-day') ,
			'desc' => __('This option overrides the "Image" option.', 'the-wedding-day'),
			'id' => 'icon',
			'default' => 'apple',
			'type' => 'icons',
		) ,
		array(
			"name" => __("Icon Color", 'the-wedding-day') ,
			"id" => "icon_color",
			"default" => 'accent6',
			"prompt" => '',
			"options" => array(
				'accent1' => __('Accent 1', 'the-wedding-day'),
				'accent2' => __('Accent 2', 'the-wedding-day'),
				'accent3' => __('Accent 3', 'the-wedding-day'),
				'accent4' => __('Accent 4', 'the-wedding-day'),
				'accent5' => __('Accent 5', 'the-wedding-day'),
				'accent6' => __('Accent 6', 'the-wedding-day'),
				'accent7' => __('Accent 7', 'the-wedding-day'),
				'accent8' => __('Accent 8', 'the-wedding-day'),
			) ,
			"type" => "select",
		) ,
		array(
			'name' => __('Icon Size', 'the-wedding-day'),
			'id' => 'icon_size',
			'type' => 'range',
			'default' => 62,
			'min' => 8,
			'max' => 100,
			'class' => 'fbs fbs-true',
		),
		array(
			'name' => __(' Icon Background', 'the-wedding-day'),
			'id' => 'background',
			'default' => 'accent1',
			'type' => 'color',
			'class' => 'fbs fbs-false',
		),

		array(
			'name' => __('Image', 'the-wedding-day') ,
			'desc' => __('This option can be overridden by the "Icon" option.', 'the-wedding-day'),
			'id' => 'image',
			'default' => '',
			'type' => 'upload',
		) ,

		array(
			'name' => __('Title', 'the-wedding-day') ,
			'id' => 'title',
			'default' => 'This is a title',
			'type' => 'text',
		) ,

		array(
			'name' => __('Main Information', 'the-wedding-day') ,
			'id' => 'main_info',
			'default' => '',
			'type' => 'text',
		) ,

		array(
			'name' => __('Description', 'the-wedding-day') ,
			'id' => 'html-content',
			'default' => 'This is Photoshop’s version of Lorem Ipsum. Proin gravida nibh vel velit auctor aliquet.
Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit.

Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit.',
			'type' => 'editor',
			'holder' => 'textarea',
		) ,

		array(
			'name' => __('Text Alignment', 'the-wedding-day') ,
			'id' => 'text_align',
			'default' => 'justify',
			'type' => 'select',
			'options' => array(
				'justify' => 'justify',
				'left' => 'left',
				'center' => 'center',
				'right' => 'right',
			)
		) ,
		array(
			'name' => __('Link', 'the-wedding-day') ,
			'id' => 'button_link',
			'default' => '/',
			'type' => 'text'
		) ,

		array(
			'name' => __('Button Text', 'the-wedding-day') ,
			'id' => 'button_text',
			'default' => 'learn more',
			'type' => 'text'
		) ,

		array(
			'name' => __('Element Animation (optional)', 'the-wedding-day') ,
			'id' => 'column_animation',
			'default' => 'none',
			'type' => 'select',
			'options' => array(
				'none' => __('No animation', 'the-wedding-day'),
				'from-left' => __('Appear from left', 'the-wedding-day'),
				'from-right' => __('Appear from right', 'the-wedding-day'),
				'fade-in' => __('Fade in', 'the-wedding-day'),
			),
		) ,

	) ,
);
