<?php
/**
 * Portfolio shortcode options
 *
 * @package wpv
 * @subpackage editor
 */


return array(
	'name' => __('Portfolio', 'the-wedding-day') ,
	'desc' => __('Please note that this element shows already created portfolio posts. To create one go to the Portfolios tab in the WordPress main navigation menu on the left - Add New. ' , 'the-wedding-day'),
	'icon' => array(
		'char' => WPV_Editor::get_icon('grid2'),
		'size' => '30px',
		'lheight' => '45px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'portfolio',
	'controls' => 'size name clone edit delete',
	'options' => array(
		
		array(
			'name' => __('Layout', 'the-wedding-day') ,
			'id' => 'layout',
			'desc' => __('Static - no filtering.<br/>
				Filtering - Enable filtering for the portfolio items depending on their category.<br/>
				Srollable - shows the portfolio items in a slider', 'the-wedding-day') ,
			'default' => '',
			'type' => 'select',
			'options' => array(
				'static'     => __('Static', 'the-wedding-day'),
				'fit-rows'   => __('Filtering - Static', 'the-wedding-day'),
				'masonry'    => __('Filtering - Masonry', 'the-wedding-day'),
				'scrollable' => __('Scrollable', 'the-wedding-day'),
			),
			'field_filter' => 'fbs',
		) ,
		array(
			'name' => __('No Paging', 'the-wedding-day') ,
			'id' => 'nopaging',
			'desc' => __('If the option is on, it will disable pagination. You can set the type of pagination in General Settings - Posts - Pagination Type. ', 'the-wedding-day') ,
			'default' => false,
			'type' => 'toggle',
			'class' => 'fbs fbs-static fbs-fit-rows fbs-masonry',
		) ,
		array(
			'name' => __('Columns', 'the-wedding-day') ,
			'id' => 'column',
			'default' => 4,
			'type' => 'range',
			'min' => 1,
			'max' => 4,
		) ,
		array(
			'name' => __('Limit', 'the-wedding-day') ,
			'desc' => __('Number of item to show per page. If you set it to -1, it will display all portfolio items.', 'the-wedding-day') ,
			'id' => 'max',
			'default' => '4',
			'min' => -1,
			'max' => 100,
			'step' => '1',
			'type' => 'range'
		) ,
		
		array(
			'name' => __('Display Title', 'the-wedding-day') ,
			'id' => 'title',
			'desc' => __('If the option is on, it will display the title of the portfolio post.<br/><br/>', 'the-wedding-day') ,
			'default' => 'false',
			'type' => 'select',
			'options' => array(
				'false' => __('No Title', 'the-wedding-day'),
				'overlay' => __('Overlay', 'the-wedding-day'),
				'below' => __('Below Media', 'the-wedding-day'),
			),
		) ,
		array(
			'name' => __('Display Description', 'the-wedding-day') ,
			'id' => 'desc',
			'desc' => __('If the option is on, it will display short description of the portfolio item.', 'the-wedding-day') ,
			'default' => false,
			'type' => 'toggle'
		) ,
		array(
			'name' => __('Button Text', 'the-wedding-day') ,
			'id' => 'more',
			'default' => __('Read more', 'the-wedding-day') ,
			'type' => 'text',
		) ,
		array(
			'name' => __('Group', 'the-wedding-day') ,
			'id' => 'group',
			'desc' => __('If the option is on, the lightbox will display left and right arrows and  you can see all the portfolio posts from the same category.', 'the-wedding-day') ,
			'default' => true,
			'type' => 'toggle',
			'class' => 'fbs fbs-static fbs-fit-rows fbs-masonry',
		) ,
		array(
			'name' => __('Categories (optional)', 'the-wedding-day') ,
						'desc' => __('All categories will be shown if none are selected. Please note that if you do not see categories, there are none created most probably. You can use ctr + click to select multiple categories.', 'the-wedding-day') ,
			'id' => 'cat',
			'default' => array() ,
			'target' => 'portfolio_category',
			'type' => 'multiselect',
		) ,
		array(
			'name' => __('Portfolio Posts (optional)', 'the-wedding-day') ,
			'desc' => __('All portfolio posts will be shown if none are selected. If you select any posts here, this option will override the category option above. You can use ctr + click to select multiple posts.', 'the-wedding-day') ,
			'id' => 'ids',
			'default' => array() ,
			'target' => 'portfolio',
			'type' => 'multiselect',
		) ,
		
		array(
			'name' => __('Title (optional)', 'the-wedding-day') ,
			'desc' => __('The title is placed just above the element.<br/><br/>', 'the-wedding-day'),
			'id' => 'column_title',
			'default' => '',
			'type' => 'text'
		) ,
		array(
			'name' => __('Title Type (optional)', 'the-wedding-day') ,
			'id' => 'column_title_type',
			'default' => 'single',
			'type' => 'select',
			'options' => array(
				'single' => __('Title with divider next to it ', 'the-wedding-day'),
				'double' => __('Title with divider below', 'the-wedding-day'),
				'no-divider' => __('No Divider', 'the-wedding-day'),
			),
		) ,
	) ,
);
