<?php
return array(
	'name' => __('Google Maps', 'the-wedding-day') ,
	'desc' => __('In order to enable Google Map you need:<br>
                 Insert the Google Map element into the editor, open its option panel by clicking on the icon- edit on the right of the element and fill in all fields nesessary.
' , 'the-wedding-day'),
	'icon' => array(
		'char' => WPV_Editor::get_icon('location1'),
		'size' => '26px',
		'lheight' => '39px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'gmap',
	'controls' => 'size name clone edit delete',
	'options' => array(
		array(
			'name' => __('Address (optional)', 'the-wedding-day') ,
			'desc' => __('Unless you\'ve filled in the Latitude and Longitude options, please enter the address that you want to be shown on the map. If you encounter any errors about the maximum number of address translation requests per page, you should either use the latitude/longitude options or upgrade to the paid Google Maps API.', 'the-wedding-day'),
			'id' => 'address',
			'size' => 30,
			'default' => '',
			'type' => 'text',
		) ,
		array(
			'name' => __('Latitude', 'the-wedding-day') ,
			'desc' => __('This option is not necessary if an address is set.<br/><br/>', 'the-wedding-day'),
			'id' => 'latitude',
			'size' => 30,
			'default' => '',
			'type' => 'text',
		) ,
		array(
			'name' => __('Longitude', 'the-wedding-day') ,
			'desc' => __('This option is not necessary if an address is set.<br/><br/>', 'the-wedding-day'),
			'id' => 'longitude',
			'size' => 30,
			'default' => '',
			'type' => 'text',
		) ,
		array(
			'name' => __('Zoom', 'the-wedding-day') ,
			'desc' => __('Default map zoom level.<br/><br/>', 'the-wedding-day'),
			'id' => 'zoom',
			'default' => '14',
			'min' => 1,
			'max' => 19,
			'step' => '1',
			'type' => 'range'
		) ,
		array(
			'name' => __('Marker', 'the-wedding-day') ,
			'desc' => __('Enable an arrow pointing at the address.<br/><br/>', 'the-wedding-day'),
			'id' => 'marker',
			'default' => true,
			'type' => 'toggle'
		) ,
		array(
			'name' => __('HTML', 'the-wedding-day') ,
			'desc' => __('HTML code to be shown in a popup above the marker.<br/><br/>', 'the-wedding-day'),
			'id' => 'html',
			'size' => 30,
			'default' => '',
			'type' => 'text',
		) ,
		array(
			'name' => __('Popup Marker', 'the-wedding-day') ,
			'desc' => __('Enable to open the popup above the marker by default.<br/><br/>', 'the-wedding-day'),
			'id' => 'popup',
			'default' => false,
			'type' => 'toggle'
		) ,
		array(
			'name' => __('Controls (optional)', 'the-wedding-day') ,
			'desc' => sprintf(__('This option is intended to be used only by advanced users and is not necessary for most use cases. Please refer to the <a href="%s" title="Google Maps API documentation">API documentation</a> for details.', 'the-wedding-day'), 'https://developers.google.com/maps/documentation/javascript/controls'),
			'id' => 'controls',
			'size' => 30,
			'default' => '',
			'type' => 'text',
		) ,
		array(
			'name' => __('Scrollwheel', 'the-wedding-day') ,
			'id' => 'scrollwheel',
			'default' => false,
			'type' => 'toggle'
		) ,
		array(
			'name' => __('Maptype (optional)', 'the-wedding-day') ,
			'id' => 'maptype',
			'default' => 'ROADMAP',
			'options' => array(
				'ROADMAP' => __('Default road map', 'the-wedding-day') ,
				'SATELLITE' => __('Google Earth satellite', 'the-wedding-day') ,
				'HYBRID' => __('Mixture of normal and satellite', 'the-wedding-day') ,
				'TERRAIN' => __('Physical map', 'the-wedding-day') ,
			) ,
			'type' => 'select',
		) ,

		array(
			'name' => __('Color (optional)', 'the-wedding-day') ,
			'desc' => __('Defines the overall hue for the map. It is advisable that you avoid gray colors, as they are not well-supported by Google Maps.', 'the-wedding-day'),
			'id' => 'hue',
			'default' => '',
			'prompt' => __('Default', 'the-wedding-day') ,
			'options' => array(
				'accent1' => __('Accent 1', 'the-wedding-day'),
				'accent2' => __('Accent 2', 'the-wedding-day'),
				'accent3' => __('Accent 3', 'the-wedding-day'),
				'accent4' => __('Accent 4', 'the-wedding-day'),
				'accent5' => __('Accent 5', 'the-wedding-day'),
				'accent6' => __('Accent 6', 'the-wedding-day'),
				'accent7' => __('Accent 7', 'the-wedding-day'),
				'accent8' => __('Accent 8', 'the-wedding-day'),
			) ,
			'type' => 'select',
		) ,
		array(
			'name' => __('Width (optional)', 'the-wedding-day') ,
			'desc' => __('Set to 0 is the full width.<br/><br/>', 'the-wedding-day') ,
			'id' => 'width',
			'default' => 0,
			'min' => 0,
			'max' => 960,
			'step' => '1',
			'type' => 'range'
		) ,
		array(
			'name' => __('Height', 'the-wedding-day') ,
			'id' => 'height',
			'default' => '400',
			'min' => 0,
			'max' => 960,
			'step' => '1',
			'type' => 'range'
		) ,


		array(
			'name' => __('Title (optioanl)', 'the-wedding-day') ,
			'desc' => __('The title is placed just above the element.<br/><br/>', 'the-wedding-day'),
			'id' => 'column_title',
			'default' => '',
			'type' => 'text'
		) ,
		array(
			'name' => __('Title Type (optional)', 'the-wedding-day') ,
			'id' => 'column_title_type',
			'default' => 'single',
			'type' => 'select',
			'options' => array(
				'single' => __('Title with divider next to it', 'the-wedding-day'),
				'double' => __('Title with divider below', 'the-wedding-day'),
				'no-divider' => __('No Divider', 'the-wedding-day'),
			),
		) ,
	) ,
);