<?php

/**
 * Contact info shortcode options
 *
 * @package wpv
 * @subpackage editor
 */

return array(
	'name' => __('Contact Info', 'the-wedding-day') ,
	'icon' => array(
		'char' => WPV_Editor::get_icon('vcard'),
		'size' => '30px',
		'lheight' => '45px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'contact_info',
	'controls' => 'size name clone edit delete',
	'options' => array(
		
		array(
			'name' => __('Name', 'the-wedding-day'),
			'id' => 'name',
			'default' => 'Nick Perry',
			'size' => 30,
			'type' => 'text'
		),
		array(
			'name' => __('Color', 'the-wedding-day'),
			'id' => 'color',
			'default' => 'accent2',
			'prompt' => __('---', 'the-wedding-day'),
			'options' => array(
				'accent1' => __('Accent 1', 'the-wedding-day'),
				'accent2' => __('Accent 2', 'the-wedding-day'),
				'accent3' => __('Accent 3', 'the-wedding-day'),
				'accent4' => __('Accent 4', 'the-wedding-day'),
				'accent5' => __('Accent 5', 'the-wedding-day'),
				'accent6' => __('Accent 6', 'the-wedding-day'),
				'accent7' => __('Accent 7', 'the-wedding-day'),
				'accent8' => __('Accent 8', 'the-wedding-day'),
				
			),
			'type' => 'select',
		),
		array(
			'name' => __('Phone', 'the-wedding-day'),
			'id' => 'phone',
			'default' => '+23898933i',
			'size' => 30,
			'type' => 'text'
		),
		array(
			'name' => __('Cell Phone', 'the-wedding-day'),
			'id' => 'cellphone',
			'default' => '+23898933i',
			'size' => 30,
			'type' => 'text'
		),
		array(
			'name' => __('Email', 'the-wedding-day'),
			'id' => 'email',
			'default' => 'office@test.com',
			'type' => 'text'
		),
		array(
			'name' => __('Address', 'the-wedding-day'),
			'id' => 'address',
			'default' => 'London',
			'size' => 30,
			'type' => 'textarea'
		),
		
	
		array(
			'name' => __('Title (optional)', 'the-wedding-day') ,
			'desc' => __('The column title is placed just above the element.', 'the-wedding-day'),
			'id' => 'column_title',
			'default' => '',
			'type' => 'text'
		) ,
		array(
			'name' => __('Title Type (optional)', 'the-wedding-day') ,
			'id' => 'column_title_type',
			'default' => 'single',
			'type' => 'select',
			'options' => array(
				'single' => __('Title with divider next to it', 'the-wedding-day'),
				'double' => __('Title with divider below', 'the-wedding-day'),
				'no-divider' => __('No Divider', 'the-wedding-day'),
			),
		) ,
		array(
			'name' => __('Element Animation (optional)', 'the-wedding-day') ,
			'id' => 'column_animation',
			'default' => 'none',
			'type' => 'select',
			'options' => array(
				'none' => __('No animation', 'the-wedding-day'),
				'from-left' => __('Appear from left', 'the-wedding-day'),
				'from-right' => __('Appear from right', 'the-wedding-day'),
				'fade-in' => __('Fade in', 'the-wedding-day'),
			),
		) ,
	) ,
);
