<?php

/**
 * Column shortcode options
 *
 * @package wpv
 * @subpackage editor
 */

return array(
	'name' => __('Column - Color Box', 'the-wedding-day') ,
	'desc' => __('Once inserted into the editor you can change its width using +/- icons on the left.<br/>
	You can insert any element into by draging and dropping it onto the box. <br/>
	You can drag and drop column into column for complex layouts.<br/>
	You can move any element outside of the column by drag and drop.<br/>
	You can set color/image background on any column.
	' , 'the-wedding-day'),
	'icon' => array(
		'char' => WPV_Editor::get_icon('table1'),
		'size' => '26px',
		'lheight' => '39px',
		'family' => 'vamtam-editor-icomoon',
	),
	'value' => 'column',
	'controls' => 'size name clone edit delete handle',
	'options' => array(


		array(
			'name' => __('Background Parallax', 'the-wedding-day'),
			'desc' => __('The parallax effect will affect only the image background of the column not the elements you place into it.<br/>
You can insert column into column with transparent background images and thus create multi layers parallax effects. <br/>
Parallax - Simple, align in the middle  - the column background is positioned - center/center   when it is in the middle of the screen.<br/>
Parallax - Fixed attachment - the column background is positioned top center when the column is at the top of the screen.<br/>
The option bellow controls speed and direction of the animation.<br/>
The parallax effect will be disabled on mobile devices as they do not yet properly support this animations and may cause different issues.
', 'the-wedding-day'),
			'id' => 'parallax_bg',
			'type' => 'select',
			'default' => 'disabled',
			'options' => array(
				'disabled' => __('Disabled', 'the-wedding-day'),
				'to-centre' => __('Simple, align at the middle', 'the-wedding-day'),
				'fixed' => __('Fixed attachment', 'the-wedding-day'),
			),
			'field_filter' => 'fbprlx',
		),

		array(
			'name' => __('Background Parallax Inertia', 'the-wedding-day'),
			'desc' => __('
The option controls speed and direction of the animation. Minus means against the scroll direction. Plus means with the direction of the scroll.
The bigger the number the higher the speed.
', 'the-wedding-day'),
			'id' => 'parallax_bg_inertia',
			'type' => 'range',
			'min' => -5,
			'max' => 5,
			'step' => 0.05,
			'default' => -.2,
			'class' => 'fbprlx fbprlx-fixed fbprlx-to-centre',
		),

		array(
			'name' => __('Full Screen Mode', 'the-wedding-day'),
			'desc' => __('Extend the background of the column to the end of the screen. This is basicly a full screen mode.', 'the-wedding-day'),
			'id' => 'extended',
			'type' => 'toggle',
			'default' => false,
			'class' => 'hide-inner hide-1-2 hide-1-3 hide-1-4 hide-1-5 hide-1-6 hide-2-3 hide-2-5 hide-3-5 hide-4-5 hide-5-6',
			'field_filter' => 'fbe',
		),

		array(
			'name' => __('Use Left/Right Padding', 'the-wedding-day') ,
			'id' => 'extended_padding',
			'default' => true,
			'type' => 'toggle',
			'class' => 'hide-inner fbe fbe-true' . (wpv_get_option('site-layout-type') == 'full' ? ' hidden': ''),
		) ,

		array(
			'name' => __('Background Color / Image', 'the-wedding-day'),
			'desc' => __('Please note that the background image left/right positions, as well as the cover option will not work as expected if the option Full Screen Mode is ON.', 'the-wedding-day'),
			'id' => 'background',
			'type' => 'background',
			'only' => 'color,image,repeat,position,size,attachment',
			'sep' => '_',
		),

		array(
			'name' => __('Vertical Padding', 'the-wedding-day'),
			'id' => 'vertical_padding',
			'type' => 'range-row',
			'ranges' => array(
				'vertical_padding_top' => array(
					'desc' => __('Top', 'the-wedding-day'),
					'default' => 0,
					'unit' => 'px',
					'min' => 0,
					'max' => 250,
				),
				'vertical_padding_bottom' => array(
					'desc' => __('Bottom', 'the-wedding-day'),
					'default' => 0,
					'unit' => 'px',
					'min' => 0,
					'max' => 250,
				),
			),
		),

		array(
			'name' => __('Class (Optional)', 'the-wedding-day') ,
			'desc' => __('Use in case you have to modify the appearance of this column.<br/><br/>', 'the-wedding-day'),
			'id' => 'class',
			'default' => '',
			'type' => 'text'
		) ,

		array(
			'name' => __('Title (optional)', 'the-wedding-day') ,
			'desc' => __('The column title is placed at the top of the column.
				<br/><br/>', 'the-wedding-day'),
			'id' => 'title',
			'default' => '',
			'type' => 'text',
			'class' => 'fbprlx fbprlx-disabled',
		) ,
		array(
			'name' => __('Title Type (optional)', 'the-wedding-day') ,
			'id' => 'title_type',
			'default' => 'single',
			'type' => 'select',
			'options' => array(
				'single' => __('Title with divider next to it', 'the-wedding-day'),
				'double' => __('Title with divider below', 'the-wedding-day'),
				'no-divider' => __('No Divider', 'the-wedding-day'),
			),
			'class' => 'fbprlx fbprlx-disabled',
		) ,
		array(
			'name' => __('Element Animation (optional)', 'the-wedding-day') ,
			'id' => 'animation',
			'default' => 'none',
			'type' => 'select',
			'options' => array(
				'none' => __('No animation', 'the-wedding-day'),
				'from-left' => __('Appear from left', 'the-wedding-day'),
				'from-right' => __('Appear from right', 'the-wedding-day'),
				'fade-in' => __('Fade in', 'the-wedding-day'),
			),
			'class' => 'fbprlx fbprlx-disabled',
		) ,


	) ,
);
