<?php

/**
 * Prev/next/view all buttons for posts and portfolio items
 *
 * @package wpv
 * @subpackage the-wedding-day
 */

global $post;

$tax = $post->post_type === 'post' ? 'category' : 'portfolio_category';

$view_all = wpv_get_option($post->post_type.'-all-items');

$prev_anchor = '<span class="icon theme">'.wpv_get_icon('theme-angle-left').'</span>';
$next_anchor = '<span class="icon theme">'.wpv_get_icon('theme-angle-right').'</span>';

?>
<span class="post-siblings">
	<?php previous_post_link( '%link', $prev_anchor, true, array(), $tax ); ?>

	<?php if(!empty($view_all)): ?>
		<a href="<?php echo $view_all ?>" class="all-items"><?php echo do_shortcode('[icon name="grid2"]') ?></a>
	<?php endif ?>

	<?php next_post_link( '%link', $next_anchor, true, array(), $tax ); ?>
</span>