<?php
	/**
	 * Actual, visible header. Includes the logo, menu, etc.
	 * @package wpv
	 */

	if(is_page_template('page-blank.php')) return;
?>
<div class="fixed-header-box">
	<header class="main-header">
		<?php get_template_part('templates/header/top-nav') ?>

		<div class="first-row">
			<a href="#" id="mp-menu-trigger" class="icon-b" data-icon="<?php wpv_icon('menu1') ?>"><?php _e('Open/Close Menu', 'the-wedding-day') ?></a>
			<div class="logo-wrapper">
				<?php
					$logo = wpv_get_option('custom-header-logo');
					$logo2x = wpv_get_option('custom-header-logo2x');

					if(!empty($logo2x)) {
						$logo_editor = wp_get_image_editor(wpv_get_attachment_file($logo2x));
						$logo2x_size = is_wp_error($logo_editor) ? array('height'=>0, 'width'=>0) : $logo_editor->get_size();
					}

				?>
				<a href="<?php echo home_url() ?>" title="<?php bloginfo( 'name' ) ?>" class="logo <?php if(empty($logo)) echo 'text-logo' ?>"><?php
					if($logo):
					?>
						<img src="<?php echo $logo;?>" alt="<?php bloginfo('name')?>" class="<?php if($logo2x) echo 'hide-hidpi' ?>"/>
						<?php if($logo2x): ?>
							<img src="<?php echo $logo2x;?>" alt="<?php bloginfo('name')?>" class="show-hidpi-inline" height="<?php echo floor($logo2x_size['height']/2) ?>"/>
						<?php endif ?>
					<?php
					else:
						bloginfo( 'name' );
					endif;
					?>
				</a>
				<?php
					$title = explode('&amp;', get_bloginfo( 'name' ), 2);
					if(wpv_get_option('combined-logo-title') && count($title) == 2):
				?>
					<div class="clearboth"></div>
					<a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" class="combined-logo-title">
						<div class="site-title-part left-name"><?php echo trim($title[0]) ?></div>
						<div class="site-title-part name-delimiter">&amp;</div>
						<div class="site-title-part right-name"><?php echo trim($title[1]) ?></div>
					</a>
				<?php endif; ?>
				<span class="logo-tagline"><?php bloginfo('description') ?></span>
			</div>
		</div>

		<div class="second-row">
			<div class="limit-wrapper">
				<div class="second-row-columns">
					<?php if(wpv_get_option('phone-num-top') != '' || wpv_get_option('enable-header-search')): ?>
						<div class="header-left">
							<?php if(wpv_get_option('phone-num-top') != ''): ?>
								<div id="phone-num"><div><?php echo do_shortcode(wpv_get_option('phone-num-top'))?></div></div>
							<?php endif ?>
						</div>
					<?php endif ?>

					<div class="header-center">
						<div id="menus">
							<nav id="main-menu">
								<?php /*  Allow screen readers / text browsers to skip the navigation menu and get right to the good stuff */ ?>
								<a href="#main" title="<?php esc_attr_e( 'Skip to content', 'the-wedding-day' ); ?>" class="visuallyhidden"><?php _e( 'Skip to content', 'the-wedding-day' ); ?></a>
								<?php
									if(has_nav_menu('menu-header'))
										wp_nav_menu(array('theme_location' => 'menu-header'));
								?>
							</nav>
						</div>
					</div>

					<?php if(wpv_get_option('phone-num-top') != '' || wpv_get_option('enable-header-search')): ?>
						<div class="header-right">
							<?php if(wpv_get_option('enable-header-search')): ?>
								<div class="search-extend expanded">
									<form action="<?php echo home_url() ?>/" class="searchform" method="get" role="search" novalidate="">
										<input type="text" required="required" placeholder="<?php _e('Search', 'the-wedding-day') ?>" name="s" value="" id="search-text-widget" />
										<button type="submit" id="top-search-submit"></button>
										<?php if(defined('ICL_LANGUAGE_CODE')): ?>
											<input type="hidden" name="lang" value="<?php echo ICL_LANGUAGE_CODE; ?>"/>
										<?php endif ?>
									</form>
								</div>
							<?php endif ?>
						</div>
					<?php endif ?>
				</div>
			</div>
		</div>
	</header>

	<img src="<?php echo WPV_THEME_IMAGES ?>svg/menu-lines.svg" onerror="this.onerror=null; this.src='<?php echo WPV_THEME_IMAGES ?>menu-lines.png'" class="menu-lines" />

	<?php do_action('wpv_header_box'); ?>
</div><!-- / .fixed-header-box -->
<div class="shadow-bottom"></div>