<?php
	/**
	 * Top bar (above the logo)
	 * @package wpv
	 */
?>
<?php if( is_active_sidebar('top-nav-sidebar') || has_nav_menu('menu-top') ): ?>
	<?php $layout = json_decode(wpv_get_option('top-bar-layout')); ?>
	<div id="top-nav-wrapper">
		<?php do_action('wpv_top_nav_before') ?>
		<nav id="top-nav" class="<?php echo implode('-', $layout) ?>">
			<div class="limit-wrapper">
				<div class="row">
					<div class="row">
						<?php
							foreach($layout as $part) {
								get_template_part('templates/header/top-nav', $part);
							}
						?>
					</div>
				</div>
			</div>
		</nav>
		<?php do_action('wpv_top_nav_after') ?>
	</div>
<?php endif ?>