<?php

/**
 * Declare plugin dependencies
 *
 * @package wpv
 */

/**
 * Declare plugin dependencies
 */
function wpv_register_required_plugins() {
	$plugins = array(
		array(
			'name' => 'Classic Editor',
			'slug' => 'classic-editor',
			'required' => true,
		),

		[
			'name'     => esc_html__( 'Classic Widgets', 'the-wedding-day' ),
			'slug'     => 'classic-widgets',
			'required' => true,
			'category' => 'required',
		],

		array(
			'name' => 'Contact Form 7',
			'slug' => 'contact-form-7',
			'required' => false,
		),

		array(
			'name' => 'WP Retina 2x',
			'slug' => 'wp-retina-2x',
			'required' => false,
		),

		array(
			'name' => 'Love it (Maintained by Vamtam)',
			'slug' => 'vamtam-love-it',
			'source' => WPV_PLUGINS . 'vamtam-love-it.zip',
			'required' => false,
			'version' => '1.0.0',
		),

		array(
			'name' => 'LayerSlider WP',
			'slug' => 'layerslider',
			'source' => WPV_PLUGINS . 'layerslider.zip',
			'required' => false,
			'version' => '5.6.2',
		),

		array(
			'name' => 'Vamtam Push Menu',
			'slug' => 'vamtam-push-menu',
			'source' => WPV_PLUGINS . 'vamtam-push-menu.zip',
			'required' => false,
			'version' => '1.2.1',
		),
	);

	$config = array(
		'default_path' => '',    // Default absolute path to pre-packaged plugins
		'is_automatic' => true,  // Automatically activate plugins after installation or not
	);

	tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'wpv_register_required_plugins' );

function vamtam_tgmpa_bulk_install_setup() {
	if ( isset( $_GET['page'] ) && $_GET['page'] === 'tgmpa-install-plugins' ) {
		// this disables the fastcgi buffering for nginx servers
		header('X-Accel-Buffering: no');
	}
}
add_action('admin_init', 'vamtam_tgmpa_bulk_install_setup');
